const nodemailer = require('nodemailer')

const credentials = require('./credentials')

const mailTransport = nodemailer.createTransport({
  host: 'smtp.sendgrid.net',
  auth: {
    user: credentials.sendgrid.user,
    pass: credentials.sendgrid.password,
  },
})

async function go() {
  try {
    const result = await mailTransport.sendMail({
      from: '"Meadowlark Travel" <info@meadowlarktravel.com>',
      to: 'joe@gmail.com, "Jane Customer" <jane@yahoo.com>, ' +
        'fred@hotmail.com',
      subject: 'Twoja wycieczka z Meadowlark Travel',
      html: '<h1>Meadowlark Travel</h1>\n<p>Dziękujemy za rezerwację wycieczki w biurze ' +
        'Meadowlark Travel.  <b>Czekamy na Twoją wizytę!</b>',
      text: 'Dziękujemy za rezerwację wycieczki w biurze Meadowlark Travel.  ' +
        'Czekamy na Twoją wizytę!',
    })
    console.log('poczta wysłana z powodzeniem: ', result)
  } catch(err) {
    console.log('nie udało się wysłać poczty: ' + err.message)
  }
}

go()
