const express = require('express')
const bodyParser = require('body-parser')
const app = express()

// poniższy wiersz jest niezbędny, aby przetwarzać dane z formularza
app.use(bodyParser.json())

const tours = [
  { id: 0, name: 'Hood River', price: 99.99 },
  { id: 1, name: 'Oregon Coast', price: 149.95 },
]

app.get('/api/tours', (req, res) => res.json(tours))

app.put('/api/tour/:id', (req, res) => {
  const p = tours.find(p => p.id === parseInt(req.params.id))
  if(!p) return res.status(410).json({ error: 'Nie istnieje taka wycieczka' })
  if(req.body.name) p.name = req.body.name
  if(req.body.price) p.price = req.body.price
  res.json({ success: true })
})

app.use('*', (req, res) => res.send(
  `<p>Skorzystaj z narzędzia <a href="https://www.getpostman.com">Postman</a> ` +
  `lub <a href="https://curl.haxx.se/">curl</a>, aby wypróbować poniższe zapytania:</p>` +
  `<pre>` +
  `GET /api/tours\n` +
  `PUT /api/tour/0 z danymi JSON { "price": 129.99 }\n` +
  `GET /api/tours`))

const port = process.env.PORT || 3000
app.listen(port, () => console.log(`\nprzechodzenie na http://localhost:${port}\n`))
