const express = require('express')
const expressHandlebars = require('express-handlebars')
const app = express()

// poniższy wiersz jest niezbędny, aby korzystać z widoków
app.engine('handlebars', expressHandlebars({ defaultLayout: 'main' }))
app.set('view engine', 'handlebars')

app.get('/', (req, res) => {
  res.render('09-home')
})

app.get('/page1', (req, res) => {
  res.render('09-page', { page: 1 })
})

app.get('/page2', (req, res) => {
  res.render('09-page', { page: 2 })
})

app.get('/page3', (req, res) => {
  res.render('09-page', { page: 3 })
})

// ostatnia funkcja w łańcuchu...jeśli wszystkie wcześniejsze trasy zawiodą,
// zostanie dopasowana poniższa trasa.  zauważ, że pasuje do każdego czasownika HTTP, nie tylko do GET.
app.use((req, res) =>
  res.status(404).render('404')
)

const port = process.env.PORT || 3000
app.listen(port, () => console.log(`\nprzechodzenie na http://localhost:${port}\n`))
