const express = require('express')

const app = express()

const port = process.env.PORT || 3000

app.get('/', (req, res) => {
  res.type('text/plain')
  res.send('Meadowlark Travel')
})

app.get('/about', (req, res) => {
  res.type('text/plain')
  res.send('O Meadowlark Travel')
})

// niestandardowa strona 404
app.use((req, res) => {
  res.type('text/plain')
  res.status(404)
  res.send('404 - Nie znaleziono')
})

// niestandardowa strona 500
app.use((err, req, res, next) => {
  console.error(err.message)
  res.type('text/plain')
  res.status(500)
  res.send('500 - Błąd serwera')
})

app.listen(port, () => console.log(
  `Express został uruchomiony pod adresem http://localhost:${port}; ` +
  `naciśnij Ctrl-C, aby zakończyć.`))
