const http = require('http')
const port = process.env.PORT || 3000

const server = http.createServer((req,res) => {
  // normalizacja url poprzez usunięcie łańcucha wyszukiwania, opcjonalnego
  // końcowego ukośnika oraz przekształcenie na małe litery
  const path = req.url.replace(/\/?(?:\?.*)?$/, '').toLowerCase()
  switch(path) {
    case '':
      res.writeHead(200, { 'Content-Type': 'text/plain' })
      res.end('Strona główna')
      break
    case '/about':
      res.writeHead(200, { 'Content-Type': 'text/plain' })
      res.end('O nas')
      break
    default:
      res.writeHead(404, { 'Content-Type': 'text/plain' })
      res.end('Nie znaleziono')
      break
  } })

server.listen(port, () => console.log(`serwer został uruchomiony na porcie ${port}; ` +
    'naciśnij Ctrl-C, aby zakończyć....'))
