import React from 'react'
import {
  BrowserRouter as Router,
  Switch,
  Route,
  Link
} from 'react-router-dom'
import logo from './img/logo.png'
import './App.css'

import Vacations from './Vacations'

function Home() {
  return (
    <div>
      <h2>Witamy w Meadowlark Travel</h2>
      <ul>
        <li>Sprawdź naszą stronę "<Link to="/about">O nas</Link>"!</li>
        <li>I nasze <Link to="/vacations">wycieczki</Link>!</li>
      </ul>
    </div>
  )
}

function About() {
  return (<i>już wkrótce</i>)
}

function NotFound() {
  return (<i>Nie znaleziono</i>)
}

function App() {
  return (
    <Router>
      <div className="container">
        <header>
          <h1>Meadowlark Travel</h1>
          <Link to="/"><img src={logo} alt="Logo Meadowlark Travel" /></Link>
        </header>
        <Switch>
          <Route path="/" exact component={Home} />
          <Route path="/about" exact component={About} />
          <Route path="/vacations" exact component={Vacations} />
          <Route component={NotFound} />
        </Switch>
      </div>
    </Router>
  )
}

export default App
