const express = require('express')
const expressHandlebars = require('express-handlebars')
const cookieParser = require('cookie-parser')
const session = require('express-session')
const catNames = require('cat-names')
const app = express()

// poniższy wiersz jest niezbędny, aby korzystać z widoków
app.engine('handlebars', expressHandlebars({ defaultLayout: 'main' }))
app.set('view engine', 'handlebars')

// poniższy wiersz jest niezbędny, aby korzystać z cookie
app.use(cookieParser())

// poniższy wiersz jest niezbędny, aby korzystać z sesji
app.use(session({ resave: false, saveUninitialized: false, secret: 'keyboard cat' }))

// plik views/greeting.hbs zawiera kod tego widoku
app.get('/greeting', (req, res) => {
  res.render('greeting', {
    message: 'Witaj, szanowny programisto!',
    style: req.query.style,
    userid: req.cookies.userid,
    username: req.session.username
  })
})

app.get('/set-random-userid', (req, res) => {
  res.cookie('userid', (Math.random()*10000).toFixed(0))
  res.redirect('/greeting')
})

app.get('/set-random-username', (req, res) => {
  req.session.username = catNames.random()
  res.redirect('/greeting')
})

app.get('*', (req, res) => res.send('Sprawdź naszą stronę <a href="/greeting">powitania</a>!'))

const port = process.env.PORT || 3000
app.listen(port, () => console.log(`\nprzechodzenie na http://localhost:${port}/greeting\n`))
