const express = require('express')
const expressHandlebars = require('express-handlebars')
const bodyParser = require('body-parser')
const app = express()

// poniższy wiersz jest niezbędny, aby korzystać z widoków
app.engine('handlebars', expressHandlebars({ defaultLayout: 'main' }))
app.set('view engine', 'handlebars')

// poniższy wiersz jest niezbędny, aby przetwarzać dane z formularza
app.use(bodyParser.urlencoded({ extended: false }))

app.get('/thank-you', (req, res) => res.render('10-thank-you'))

// kod tego widoku znajduje się w pliku views/10-home.hbs
app.get('*', (req, res) => res.render('10-home'))

app.post('/process-contact', (req, res) => {
  console.log(`otrzymano dane kontaktowe od ${req.body.name} <${req.body.email}>`)
  res.redirect(303, '/thank-you')
})

const port = process.env.PORT || 3000
app.listen(port, () => console.log(`\nprzechodzenie na http://localhost:${port}\n`))
