const express = require('express')
const expressHandlebars = require('express-handlebars')
const app = express()

// poniższy wiersz jest niezbędny, aby korzystać z widoków
app.engine('handlebars', expressHandlebars({ defaultLayout: 'main' }))
app.set('view engine', 'handlebars')

// plik views/error.hbs zawiera kod tego widoku
app.get('/bad-bad-not-good', (req, res) => {
  // symulujemy coś złego
  throw new Error("coś się nie udało!")
})

app.get('*', (req, res) => res.render('08-click-here'))

app.use((err, req, res, next) => {
  console.error('** BŁĄD SERWERA: ' + err.message)
  res.status(500).render('08-error', { message: "nie powinieneś tego klikać!" })
})

const port = process.env.PORT || 3000
app.listen(port, () => console.log(`\nprzechodzenie na http://localhost:${port}\n`))
