const express = require('express')
const cluster = require('cluster')

const app = express()

app.use((req, res, next) => {
  if(cluster.isWorker)
    console.log(`Węzeł roboczy ${cluster.worker.id} otrzymał żądanie`)
  next()
})

app.get('/fail', (req, res) => {
    throw new Error('Nie!')
})

app.get('/epic-fail', (req, res) => {
  process.nextTick(() => {
    throw new Error('Bum!')
  })
  res.send('embarrased')
})

app.get('*', (req, res) => res.send('online'))

process.on('uncaughtException', err => {
  console.error('NIEOBSŁUŻONY WYJĄTEK\n', err.stack);
  // w tym miejscu należy wszystko posprzątać, zamknąć
  // połączenia z bazą danych, itd. Prawdopodobnie warto
  // też powiadomić tutaj zespół operacji
  // o wystąpieniu krytycznego błędu; można w tym celu
  // wysłać e-mail lub skorzystać z usługi, takiej jak
  // Sentry, Rollbar lub New Relic
  process.exit(1)
})

function startServer(port) {
  app.listen(port, function() {
    console.log(`Express został uruchomiony w trybie ${app.get('env')} ` +
      `pod adresem http://localhost:${port}` +
      `; naciśnij Ctrl-C, aby zakończyć.`)
  })
}

if(require.main === module) {
  // aplikacja uruchomiona bezpośrednio; start serwera aplikacji
  startServer(process.env.PORT || 3000)
} else {
  // aplikacja zaimportowana jako moduł za pomocą składni "require": export
  // funkcja tworząca serwer
  module.exports = startServer
}
