# Przykłady z rozdziału 5. - Tworzenie aplikacji internetowych z użyciem Node i Express, Wydanie II

## QA: testy jednostkowe, testy integracyjne i lintowanie

Ten rozdział omawia testy jednostkowe, testy integracyjne i lintowanie. Tylko jeden przykład obejmuje wszystkie wspomniane zagadnienia, skonfigurowane zgodnie z treścią rozdziału 5.


### Konfiguracja

Przykład z tego rozdziału zawiera zależności od modułów Node (`express` i `express-handlebars`).  Te zależności są uwzględnione w pliku _package.json_.  Jednak po pobraniu tego kodu nie będą zainstalowane (_package.json_ jest tylko plikiem manifestu).  Aby je zainstalować, należy wykonać poniższe polecenie:

```
npm install
```

### Running

Minimalny przykład; wykorzystuje Express, lecz ma ograniczone działanie.  Uruchamianie:

```
node 00-meadowlark
```

Następnie otwórz adres _http://localhost:3000/about_ w przeglądrce.

### Uruchamianie testów (jednostkowych i integracyjnych)

Aby uruchomić testy jednostkowe (patrz _lib/&#95;&#95;tests&#95;&#95;/handlers.test.js_) i integracyjne (patrz _integration-tests/basic-navigation.test.js_):

```
npm test
```

Aby sprawdzić sposób konfiguracji testów, należy zajrzeć do skryptu `test` w pliku _package.json_.

### Pokrycie testami

Aby sprawdzić pokrycie testami, należy wykonać poniższe polecenie:

```
npm test -- --coverage
```

### Lintowanie

Aby wykonać lintowanie aplikacji, należy wykonać poniższe polecenie:

```
npm lint
```
