<?php

// parallel-download.php

$start = microtime(true);

// // równoczesne pobieranie dwóch najlepszych rozwiązań technologicznych

require __DIR__
    . DIRECTORY_SEPARATOR
    .'..'
    . DIRECTORY_SEPARATOR
    . 'vendor'
    . DIRECTORY_SEPARATOR
    .'autoload.php';

$loop = React\EventLoop\Factory::create();

$files = array(
    'node-v10.15.1.tar.gz' => 'http://nodejs.org/dist/v10.15.1/node-v10.15.1.tar.gz',
    'php-7.3.2.tar.gz' => 'http://it.php.net/get/php-7.3.2.tar.gz/from/this/mirror',
);

foreach ($files as $file => $url) {

    $readStream = fopen($url, 'r');
    $writeStream = fopen($file, 'w');

    stream_set_blocking($readStream, 0);
    stream_set_blocking($writeStream, 0);

    $read = new React\Stream\Stream($readStream, $loop);
    $write = new React\Stream\Stream($writeStream, $loop);

    $read->on('end', function () use ($file, &$files) {
        unset($files[$file]);
        echo "Zakończono pobieranie $file\n";
    });

    $read->pipe($write);

}

$loop->addPeriodicTimer(5, function ($timer) use (&$files) {
    if (0 === count($files)) {
        $timer->cancel();
    }

    foreach ($files as $file => $url) {

        $mbytes = filesize($file) / (1024 * 1024);
        $formatted = number_format($mbytes, 3);
        echo "$file: $formatted MiB\n";

    }
});

echo "Ten skrypt pokazuje co 5 sekund stan pobierania.\n";

$loop->run();

$time = microtime(true) - $start;

echo 'Czas, który upłynął: ' . $time . PHP_EOL;

echo memory_get_usage() . ' bajtów' . PHP_EOL;
