from fastapi import FastAPI
from fastapi import Response

app = FastAPI()

@app.get("/hi")
def greet():
    return "Witaj? Świecie?"

@app.get("/happy")
def happy(status_code=200):
    return ":)"

@app.get("/header/{name}/{value}")
def header(name: str, value: str, response:Response):
    response.headers[name] = value
    return "normalne ciało"

if __name__ == "__main__":
    import uvicorn
    uvicorn.run("hello:app", reload=True)
