from model.creature import Creature
from errors import Missing, Duplicate
import csv

# sztuczne dane, które w rodziale dziesiątym zostaną zastąpione prawdziwą bazą SQL
_creatures = [
    Creature(name="Yeti",
             aka="Abominable Snowman",
             country="CN",
             area="Himalaje",
             description="Hirsute Himalayan"),
    Creature(name="Bigfoot",
             description="Kuzyn Yeti Edek",
             country="US",
             area="*",
             aka="Sasquatch"),
    ]

def find(name: str) -> Creature | None:
    for c in _creatures:
        if c.name == name:
            return c
    return None

def check_missing(name: str):
    if not find(name):
        raise Missing(msg=f"Kreatura {name} nie znaleziona")
    
def check_duplicate(name: str):
    if find(name):
        raise Duplicate(msg=f"Kreatura {name} już istnieje")


def read_csv(fname: str) -> dict[tuple]:
    with open(fname) as file:
        data = [row for row in csv.reader(file, delimiter="|")]
    return data

def get_all() -> list[Creature]:
    """Zwróć wszystkie stworzenia"""
    #return _creatures    
    data = read_csv("../creature.psv")
    return [Creature(name=row[0], country=row[1], area=row[2], description=row[3], aka=row[4]) for row in data]

def get_one(name: str) -> Creature:
    check_missing(name)
    """Zwróć jedno stworzenie"""
    for _creature in _creatures:
        if _creature.name == name:
            return _creature
    

# Poniższe funkcje są na razie niefunkcjonalne,
# więc działają bez faktycznego modyfikowanie
# listy _creatures
def create(creature: Creature) -> Creature:
    """Dodać nowe stworzenie"""
    check_duplicate(creature.name)
    return creature

def modify(name: str, creature: Creature) -> Creature:
    """Częściowo zmodyfikuj stworzenie"""
    check_missing(name)
    return creature

def replace(creature: Creature) -> Creature:
    """Całkowicie zastąp stworzenie"""
    check_missing(creature.name)
    return creature

def delete(name: str):
    """Usuń stworzenie, zwróć None, jeśli znaleziono."""
    check_missing(name)
    return None
