from matplotlib import pyplot as plt
import numpy as np
t = np.array([10, 10, 10, 10, 30, 40, 40, 50, 70, 70, 80, 80, 80, 80, 100, 100, 100])

counts, bins, _ = plt.hist(t, bins=10, color='orange', edgecolor='black')

bin_centers = 0.5 * (bins[:-1] + bins[1:])

plt.xticks(bins)

plt.yticks(np.arange(0, max(counts) + 1, step=1))

plt.xlabel('Wartość zmiennej')
plt.ylabel('Liczba wystąpień')
plt.show()
