import numpy as np
from scipy import stats
import matplotlib.pyplot as plt

X = np.array([-5, -4, -3, -2, 1, 0, 2, 4, 5, 7, 8, 10, 12, 13])
Y = np.array([4, 5, 6, 8, 9, 9.5, 11, 12, 10, 9.5, 11.5, 14, 16, 17])

B, A, _, _, _ = stats.linregress(X, Y)
plt.scatter(X, Y, color='green')

x = np.linspace(np.min(X), np.max(X), 500)
y = A + B * x

plt.plot(x, y, '-k', label='Y = {:.2f} + {:.2f}*X'.format(A, B))
#plt.plot(x, 6 +0.7*x, '--', color='red',  label='Y1=6 + 0,7*X')
#plt.plot(x, 9 +0.5*x, '-.', color='grey', label='Y2=9 + 0,5*X')

plt.axvline(x=0, color='red', linestyle='--', linewidth=1)

plt.title('Przykład regresji liniowej')
plt.xlabel('X')
plt.ylabel('Y')
plt.legend(loc='best')
plt.grid()
plt.show()



