import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
from sklearn.cluster import KMeans
from sklearn.preprocessing import StandardScaler
from mpl_toolkits.mplot3d import Axes3D
data = pd.read_excel('dane3D.xlsx') # Wczytanie danych z pliku Excel
X = data[['wiek', 'punktacja', 'czasEkranowy']].values

scaler = StandardScaler()
X_scaled = scaler.fit_transform(X)

wcss = []
for i in range(1, 11):
    kmeans = KMeans(n_clusters=i, init='k-means++', random_state=42)
    kmeans.fit(X_scaled)
    wcss.append(kmeans.inertia_)

plt.plot(range(1, 11), wcss)
plt.title('Metoda \"łokcia\"')
plt.xlabel('Liczba klastrów')
plt.ylabel('WCSS')
plt.show()

k = np.argmin(np.diff(wcss)) + 2
print("Wybrana liczba klastrów na podstawie metody 'łokcia'", k)

kmeans = KMeans(n_clusters=k, init='k-means++', random_state=42)
y_pred = kmeans.fit_predict(X_scaled)

X_inverse = scaler.inverse_transform(X_scaled)

centroids_scaled = kmeans.cluster_centers_
centroids = scaler.inverse_transform(centroids_scaled)

fig = plt.figure()
ax = fig.add_subplot(111, projection='3d')

def get_marker(cluster):
    markers = ['o', 's', '^', 'P', 'D']  # Dodaj więcej symboli, jeśli jest więcej klastrów
    return markers[cluster % len(markers)]

for cluster_id in np.unique(y_pred):
    cluster_points = X_inverse[y_pred == cluster_id]
    marker = get_marker(cluster_id)
    ax.scatter(cluster_points[:, 0], cluster_points[:, 1], cluster_points[:, 2], marker=marker, label=f'Klaster {cluster_id}')

ax.scatter(centroids[:, 0], centroids[:, 1], centroids[:, 2], s=200, marker='P', c='black', label='Centroidy')

ax.set_xlabel('Wiek')
ax.set_ylabel('Punktacja')
ax.set_zlabel('Czas ekranowy')
ax.legend()
plt.show()
data['Klaster'] = y_pred

data.to_excel('dane3D-wyniki.xlsx', index=False)
print(data.head(300))

probka = pd.DataFrame([[24, 6005, 60]], columns=['Wiek', 'Punktacja', 'CzasEkranowy'])
probka_scaled = scaler.transform(probka.values)  # Standaryzacja nowej próbki danych
nowy_klaster = kmeans.predict(probka_scaled)
print("Przewidziany numer klastra dla nowej próbki danych:", nowy_klaster[0])
