# Książka: patrz "Klasy — modelowanie rzeczywistości" (Rozdział 1.)
class Complex:
       def __init__(self, pRe=0, pIm=0, pKomentarz=""):
              self.__re = pRe
              self.__im = pIm
              self.komentarz=pKomentarz
              print("Narodził się nowy obiekt... Nie zapomnij o deklaracji 800+")

       def __str__(self):
              if self.im >= 0:
                     return str(self.__re) + "+" + str(self.__im) + "*i"
              else:
                     return str(self.__re) + str(self.__im) + "*i"
       def wypisz(self):
              print(self.komentarz)

       def dodaj(self, x2):  # Ta metoda dodaje do bieżącego obiektu inny obiekt 'x2' klasy Complex
              self.__im = self.__im + x2.__im  # x2 podajemy jako parametr wywołania metody
              self.__re = self.__re + x2.__re #  Obiekt x zostanie modyfikowany!

       # Arytmetyka liczb zespolonych: jeśli x1=a+b·i oraz x2=c+d·i to x1+x2 = (a+c) + (b + d)·i
       def __add__(self, x2):
              return Complex(self.__re + x2.__re, self.__im + x2.__im)

       # Odczyt i zapis
       @property
       def re(self):
              return self.__re
       @re.setter
       def re(self, korekta):
              self.__re= korekta

       # Tylko odczyt
       @property
       def im(self):
              return self.__im
# --------- Kilka przykładów użycia: ------------------------------------------------------------
n=Complex()
n.komentarz="Uczymy się OOP w Pythonie"
print(f"Obiekt 'n' to [{n}]")
print("Komentarz zawarty w 'n'=", end="")
n.wypisz()

x = Complex(5,8)           # x = 5 + 8*i
print("x PRZED modyfikacją 're' ==>", x)
y = Complex(3,-2)               # y = 3 - 2*i
x.re=6
print("x PO modyfikacji 're=6'  ==>", x)
#x.im=33333333  #--> Python zgłosi błąd "AttributeError: property 're' of 'Complex' object has no setter"
print(f" x = {x}, y = {y}, x+y={x+y}")