import pandas as pd
from sklearn.model_selection import train_test_split
from sklearn.linear_model import LogisticRegression
from sklearn.metrics import accuracy_score
from sklearn.preprocessing import StandardScaler

dane = pd.read_excel("egzaminy.xlsx", header=0)
print(dane.head(5))

X = dane.drop(columns=['egzamin_ok'])
y = dane['egzamin_ok']

X_train, X_test, y_train, y_test = train_test_split(X, y, test_size=0.2, random_state=42)

model_bez_skalowania = LogisticRegression()
model_bez_skalowania.fit(X_train, y_train)

y_pred_bez_skalowania = model_bez_skalowania.predict(X_test)
accuracy_bez_skalowania = accuracy_score(y_test, y_pred_bez_skalowania)

print("Dokładność modelu bez skalowania danych:", accuracy_bez_skalowania)

scaler = StandardScaler()
X_train_scaled = scaler.fit_transform(X_train)

model_ze_skalowaniem = LogisticRegression()
model_ze_skalowaniem.fit(X_train_scaled, y_train)

X_test_scaled = scaler.transform(X_test)
y_pred_ze_skalowaniem = model_ze_skalowaniem.predict(X_test_scaled)
accuracy_ze_skalowaniem = accuracy_score(y_test, y_pred_ze_skalowaniem)

print("Dokładność modelu ze skalowaniem danych:", accuracy_ze_skalowaniem)

# Sprawdzenie predykcji dla zestawu zmiennych niezależnych ze skalowaniem
# Przykładowe dane dla predykcji
moje_dane = pd.DataFrame(
    { "czas_nauki":  [1,   3],
            "wiek":  [12, 13],
        "czas_net":  [2,   3],
      "liczba_kont": [1,   5],
      "gracz":       [True, False]})
print(moje_dane)

def predict_new_dane(model, scaler, nowe_dane):
    nowe_sc = scaler.transform(nowe_dane)
    return model.predict(nowe_sc)

print("Predykcje dla zmiennych niezależnych bez skalowania:", model_bez_skalowania.predict(moje_dane))

nowe_pred_skal = predict_new_dane(model_ze_skalowaniem, scaler, moje_dane)
print("Predykcje dla zmiennych niezależnych ze skalowaniem:", nowe_pred_skal)

