import pandas as pd
import matplotlib.pyplot as plt
import seaborn as sb

def float_to_date(float_number):
    parts = str(float_number).split('.')
    year = int(parts[0])
    month_fraction = float('0.' + parts[1])
    month = round(month_fraction * 12)
    if month == 0:
        month = 12
        year -= 1
    return f"{year}.{month:02d}"
nazwy_pl = ['Nr', 'Data_transakcji', 'Wiek_domu', 'Odleglosc_przystanek', 'Sklepy_w_poblizu', 'Geo_lat', 'Geo_long', 'Cena']

df = pd.read_excel('UCI/Real estate valuation data set.xlsx', index_col=0, header=0, names=nazwy_pl)
df['Data_transakcji'] = df['Data_transakcji'].apply(float_to_date)
df['Data_transakcji'] = pd.to_datetime(df['Data_transakcji'], format='%Y.%m')
"""
print("Statystyki podsumowujące:\n", df.describe())
sb.pairplot(df, diag_kind="kde")
plt.show()
# Wyświetlenie tabeli danych i zapis do pliku 'Real estate valuation data set-pl.xlsx'
print(df.head(10))
df.to_excel('UCI/RealEstate-pl.xlsx', index=False)
exit()
# ---------------------------------------------------------------------------------------------
"""
"""
# Histogramy dla wszystkich kolumn numerycznych
df.hist(figsize=(12, 8))
plt.suptitle('Histogramy dla wszystkich kolumn numerycznych', fontsize=16)
plt.show()
# Wykres pudełkowy dla wybranej kolumny
plt.figure(figsize=(8, 6))
plt.boxplot(df['Cena'])
plt.title('Wykres pudełkowy dla ceny domów')
plt.ylabel('Cena')
plt.show()
exit()
"""

# ---------------------------------------------------------------------------------------------
"""
correlation_matrix = df.corr() # Macierz korelacji
print("Macierz korelacji:")
print(correlation_matrix)
print()
exit()
"""
# ---------------------------------------------------------------------------------------------
"""
# Rozkład liczby transakcji w czasie
df['Data_transakcji'] = pd.to_datetime(df['Data_transakcji'])  # Konwersja do formatu daty
transactions_over_time = df.groupby(df['Data_transakcji'].dt.to_period('M')).size()
transactions_over_time.plot(figsize=(12, 6), marker='o')
plt.title('Rozkład liczby transakcji w czasie', fontsize=16)
plt.xlabel('Data transakcji', fontsize=12)
plt.ylabel('Liczba transakcji', fontsize=12)
plt.show()

# Średnia cena domów w czasie
mean_price_over_time = df.groupby(df['Data_transakcji'].dt.to_period('M'))['Cena'].mean()
mean_price_over_time.plot(figsize=(12, 6), marker='o')
plt.title('Średnia cena domów w czasie', fontsize=16)
plt.xlabel('Data transakcji', fontsize=12)
plt.ylabel('Średnia cena domu', fontsize=12)
plt.show()
exit()
"""

"""
# Średnia cena domów w zależności od liczby sklepów w okolicy
mean_price_by_shops = df.groupby('Sklepy_w_poblizu')['Cena'].mean()
mean_price_by_shops.plot(kind='bar', figsize=(10, 6))
#plt.title('Średnia cena nieruchomości w zależności od liczby sklepów w okolicy', fontsize=16)
plt.xlabel('Liczba sklepów w pobliżu', fontsize=12)
plt.ylabel('Średnia cena domu', fontsize=12)
plt.xticks(rotation=0)
plt.show()
"""
"""
# Średnia cena domów w zależności od odległości od przystanku
import numpy as np
# Tworzymy listę równomiernie rozłożonych punktów na osi X
x_values = np.linspace(df['Odleglosc_przystanek'].min(), df['Odleglosc_przystanek'].max(), num=8)
# Obliczamy średnie ceny domów dla każdego z tych punktów
mean_prices = [df[df['Odleglosc_przystanek'].between(x - 100, x + 100)]['Cena'].mean() for x in x_values]
# Tworzymy wykres punktowy
plt.figure(figsize=(10, 6))
plt.plot(x_values, mean_prices, marker='.')
plt.xlabel('Odległość od przystanku', fontsize=12)
plt.ylabel('Średnia cena domu', fontsize=12)
plt.title('Średnia cena domów w zależności od odległości od przystanku', fontsize=16)
plt.grid(True)
plt.show()
"""


# Analiza przestrzenna
import folium
# Tworzenie mapy z kafelkami w języku angielskim
m = folium.Map(location=[df['Geo_lat'].mean(), df['Geo_long'].mean()], zoom_start=10, tiles='cartodbpositron')
# Dodawanie znaczników dla każdego punktu
for lat, lon, cena in zip(df['Geo_lat'], df['Geo_long'], df['Cena']):
    folium.CircleMarker(
        location=[lat, lon],
        radius=5,
        color='black',
        fill=True,
        fill_color='black',
        fill_opacity=0.5,
        popup=f'Cena: {cena}'
    ).add_to(m)
m.show_in_browser() # Wyświetlanie mapy




