# Dane z: https://en.wikipedia.org/wiki/Anscombe%27s_quartet
import numpy as np
from scipy import stats

X1 = np.array([10.0, 8.0, 13.0, 9.0, 11.0, 14.0, 6.0, 4.0, 12.0, 7.0, 5.0])
Y1 = np.array([8.04, 6.95, 7.58, 8.81, 8.33, 9.96, 7.24, 4.26, 10.84, 4.82, 5.68])
X2 = np.array([10.0, 8.0, 13.0, 9.0, 11.0, 14.0, 6.0, 4.0, 12.0, 7.0, 5.0])
Y2 = np.array([9.14, 8.14, 8.74, 8.77, 9.26, 8.10, 6.13, 3.10, 9.13, 7.26, 4.74])
X3 = np.array([10.0, 8.0, 13.0, 9.0, 11.0, 14.0, 6.0, 4.0, 12.0, 7.0, 5.0])
Y3 = np.array([7.46, 6.77, 12.74, 7.11, 7.81, 8.84, 6.08, 5.39, 8.15, 6.42, 5.73])
X4 = np.array([8.0, 8.0, 8.0, 8.0, 8.0, 8.0, 8.0, 19.0, 8.0, 8.0, 8.0])
Y4 = np.array([6.58, 5.76, 7.71, 8.84, 8.47, 7.04, 5.25, 12.50, 5.56, 7.91, 6.89])

print(f"Średnia:   X1:{np.mean(X1):.3f},  X2:{np.mean(X2):.3f}, X3:{np.mean(X3):.3f}, X4: {np.mean(X4):.3f}")
print(f"Wariancja: X1:{np.var(X1, ddof=1):.3f}, X2:{np.var(X2, ddof=1):.3f}, X3:{np.var(X3, ddof=1):.3f}, X4: {np.var(X4, ddof=1):.3f}")
print(f"Średnia:   Y1:{np.mean(Y1):.3f},  Y2:{np.mean(Y2):.3f}, Y3:{np.mean(Y3):.3f}, Y4: {np.mean(Y4):.3f}")
print(f"Wariancja: Y1:{np.var(Y1, ddof=1):.3f},  Y2:{np.var(Y2, ddof=1):.3f}, Y3:{np.var(Y3, ddof=1):.3f}, Y4: {np.var(Y4, ddof=1):.3f}")

print(f"Korelacja między X1 i Y1: {np.corrcoef(X1, Y1)[0, 1]:.4f}")
print(f"Korelacja między X2 i Y2: {np.corrcoef(X2, Y2)[0, 1]:.4f}")
print(f"Korelacja między X3 i Y3: {np.corrcoef(X3, Y3)[0, 1]:.4f}")
print(f"Korelacja między X4 i Y4: {np.corrcoef(X4, Y4)[0, 1]:.4f}")

B, A, r_value, p_value, std_err = stats.linregress(X1, Y1)
print(f"Parametry linii regresji  Y1 = A + B * X1: A = {A:.3f}, B = {B:.3f}")
B, A, r_value, p_value, std_err = stats.linregress(X2, Y2)
print(f"Parametry linii regresji  Y2 = A + B * X2: A = {A:.3f}, B = {B:.3f}")
B, A, r_value, p_value, std_err = stats.linregress(X3, Y3)
print(f"Parametry linii regresji  Y3 = A + B * X3: A = {A:.3f}, B = {B:.3f}")
B, A, r_value, p_value, std_err = stats.linregress(X4, Y4)
print(f"Parametry linii regresji  Y4 = A + B * X4: A = {A:.3f}, B = {B:.3f}")