import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
from scipy.cluster.hierarchy import dendrogram, linkage, fcluster
from sklearn.preprocessing import StandardScaler

data = pd.read_excel('dane2D.xlsx')
X = data[['wiek', 'punktacja']].values

scaler = StandardScaler()
X_scaled = scaler.fit_transform(X)

Z = linkage(X_scaled, method='ward')
print(type(Z))
print(Z)

plt.title('Dendrogram')
dendrogram(Z)

plt.xlabel('Indeksy')
plt.ylabel('Odległość')
plt.show()

last = Z[-10:, 2]
last_rev = last[::-1]
idxs = np.arange(1, len(last) + 1)
plt.plot(idxs, last_rev, marker='o')
plt.xlabel('Liczba klastrów')
plt.ylabel('Odległość')
plt.title("Metoda \"łokcia\"")
plt.xticks(idxs)
plt.grid(True)
plt.show()

k = np.argmin(np.diff(last)) + 2
print("Wybrana liczba klastrów na podstawie metody 'łokcia':", k)

clusters = fcluster(Z, k, criterion='maxclust')

def get_marker(cluster):
    markers = ['o', 's', '^', 'P', 'D']
    return markers[cluster % len(markers)]

for cluster_id in np.unique(clusters):
    cluster_points = X[clusters == cluster_id]
    marker = get_marker(cluster_id)
    plt.scatter(cluster_points[:, 0], cluster_points[:, 1], marker=marker, label=f'Klaster {cluster_id}')
plt.xlabel('Wiek')
plt.ylabel('Punktacja')
plt.title('Sytuacja po klastrowaniu')
plt.legend()
plt.grid(True)
plt.show()

data['klaster'] = clusters
data.to_excel('dane2D-wyniki.xlsx')


