import pandas as pd
import numpy as np
# index_col=0 oznacza, że użyjemy pierwszej kolumny jako indeksu danych (transakcje są numerowane od 1. do 414.)
nazwy_pl=['Nr','Data_transakcji','Wiek_domu','Odleglosc_przystanek','Sklepy_w_poblizu','Geo_lat','Geo_long','Cena']
df = pd.read_excel('UCI/Real estate valuation data set.xlsx', index_col=0, header=0, names=nazwy_pl)
#df.drop('Geo_lat', axis=1, inplace=True)
#df.drop('Geo_long', axis=1, inplace=True)
#df.drop('Data_transakcji', axis=1, inplace=True)
#df.drop('Odleglosc_przystanek', axis=1, inplace=True)
#df.drop('Sklepy_w_poblizu', axis=1, inplace=True)

# Wyświetlenie fragmentu tabeli danych
print(df.head(10))

from sklearn.linear_model import LinearRegression
model = LinearRegression()

from sklearn.model_selection import train_test_split


X = df.iloc[:, :-1].values
y = df.iloc[:, -1].values
X_train, X_test, y_train, y_test = train_test_split(X, y, test_size = 0.2, random_state = 42)

model.fit(X_train, y_train)
y_pred = model.predict(X_test)

from sklearn.metrics import r2_score
r2 = r2_score(y_test, y_pred)
print("r2=", r2)

k = X_test.shape[1]
n = X_test.shape[0]
adj_r2 = 1-(1-r2)*(n-1)/(n-k-1)
print("adj_r2=",adj_r2)

print('Współczynniki funkcji korelacji B1, B2, ..., Bn: ', model.coef_)
print('Wyraz wolny (ang. intercept):', model.intercept_)

dane_testowe=np.array([2013.500, 6.5, 90.45606, 9, 24.97433, 121.5431]) # 53.91109130428413 vs. 63.0
#dane_testowe=np.array([2012.833, 0, 185.4296, 0, 24.9711, 121.5317])  # 41.361936426752436 vs. 55.2

print("Dane testowe:",dane_testowe) # Pojedyncza próbka

print("Predykcja dla danych testowych  obliczana ręcznie:", model.intercept_+\
      np.dot(model.coef_, dane_testowe))
print("Predykcja dla danych testowych, metoda predict():",\
      model.predict(dane_testowe.reshape(1, -1))[0])

