import nltk
from vaderSentiment.vaderSentiment import SentimentIntensityAnalyzer
# Patrz książka:
#nltk.download('vader_lexicon') # Czynność jednokrotna

# Tutaj ew. dalsze pre-procesowanie tekstów [...]

analyzer = SentimentIntensityAnalyzer()

dokumenty = [
  "Próbowałem tego użyć, dramat. Nie otwiera się żadne okno. Totalne dno. NIE kupujcie",
  "Sporo osób twierdzi, że jest całkiem niezły, wy też? Ktoś to próbował instalować?",
  "I tried to use it, windows are not opening at all! I have doubts who would like to use it, strange software...",
]
def analyze_sentiment(text): # Funkcja pomocnicza
    score = analyzer.polarity_scores(text)
    if score['compound'] >= 0.05:
        return "Pozytywny"
    elif score['compound'] <= -0.05:
        return "Negatywny"
    else:
        return "Neutralny"

for d in dokumenty:
    sentiment = analyze_sentiment(d)
    print("Sentyment tekstu:", sentiment)
