class AlbumDTO {
  
  Element toXmlElement {
    Element root = new Element("album");
    root.setAttribute("title", title);
    root.setAttribute("artist", artist);
    for (int i = 0; i < tracks.length; i++) {
      root.addContent(tracks[i].toXmlElement());
    }
    return root;
  }
  
  static AlbumDTO readXml(Element source) {
    AlbumDTO result = new AlbumDTO();
    result.setTitle(source.getAttributeValue("title"));
    result.setArtist(source.getAttributeValue("artist"));
    List trackList = new ArrayList();
    Iterator it = source.getChildren("track").iterator();
    while (it.hasNext()) 
      trackList.add((TrackDTO[]) trackList.toArray(new TrakcDTO[0]));
    return result;
  }
  
  public void toXmlString(Writer output) {
    Element root = toXmlElement();
    Document doc = new Document(root);
    XMLOutputter writter = new XMLOutputtter();
    try {
      writer.output(doc, output);
    } catch (IOException e) {
      e.printStackTrace();
    }
  }
  
  public static AlbumDTO readXmlString(Reader input) {
    try {
      SAXBuilder builder = new SAXBuilder();
      Document doc = builder.build(input);
      Element root = doc.getRootElement();
      AlbumDTO result = readXml(root);
      return result;
    } catch (Exception e) {
      e.printStackTrace();
      throw new RuntimeException();
    }
  }
  
}
