class DataMap { 
   //...
 
   private Class domainClass;
   private String tableName;
   private List columnMaps = new ArrayList();
 
   //...
   
   public String columnList() {
     StringBuffer result = new StringBuffer(" ID");
     for (Iterator it = columnMaps.iterator(); it.hasNext();) {
       result.append(",");
       ColumnMap columnMap = (ColumnMap) it.next();
       result.append(columnMap.getColumnName());
     }
     return result.toString();
   }
   
   public String getTableName() {
     return tableName;
   }
   
   public String updateList() {
     StringBuffer result = new StringBuffer(" SET ");
     for (Iterator it = columnMaps.iterator(); it.hasNext();) {
       ColumnMap columnMap = (ColumnMap) it.next();
       result.append(columnMap.getColumnName());
       result.append("=?,");
     }
     result.setLength(result.length() - 1);
     return result.toString();
   }  
   
   public Iterator getColumns() {
     return Collections.unmodifiableCollection(columnMaps).iterator();
   }
   
   public String insertList() {
     StringBuffer result = new StringBuffer();
     for (int i = 0; i < columnMaps.size(); i++) {
       result.append(",");
       result.append("?");
     }
     return result.toString();
   }
    
   public String getColumnForField (String fieldName) {
     for (Iterator it = getColumns(); it.hasNext();) {
       ColumnMap columnMap = (ColumnMap)it.next();
       if (columnMap.getFieldName().equals(fieldName))
         return columnMap.getColumnName();
     }
     throw new ApplicationException ("Nie mona znale kolumny odpowiadajcej polu " + fieldName);
   }

  
 }

//###########################################################

class ColumnMap {
  //...
  
  private String columnName;
  private String fieldName;
  private Field field;
  private DataMap dataMap;
  
  //...
  
  public ColumnMap(String columnName, String fieldName, DataMap dataMap) {
    this.columnName = columnName;
    this.fieldName = fieldName;
    this.dataMap = dataMap;
    initField();
  }
  
  private initField() {
    try {
      field = dataMap.getDomainClass().getDeclaredField(getFieldName());
      field.setAccessible(true);
    } catch (Exception e) {
      throw new ApplicationException("Nie mona zainicjalizowa pola: " + fieldName, e);
    }
  }
  
  
  
  
}

//###########################################################

class PersonMapper { //...
  
  protected void loadDataMap() {
    dataMap = new DataMap(Person.class, "people");
    dataMap.addColumn ("lastname", "varchar", "lastName");
    dataMap.addColumn ("firstname", "varchar", "firstName");
    dataMap.addColumn ("number_of_dependants", "int", "numberOfDependants");
  }
  
}

//###########################################################

class Mapper { //...

  public Object findObject(Long key) {
    if (uow.isLoaded(key)) return uow.getObject(key);
    String sql = "SELECT " + dataMap.columnList() + " FROM " + 
                 dataMap.getTableName() + " WHERE ID = ?";
    PreparedStatement stmt = null;
    ResultSet rs = null;
    DomainObject result = null;
    try {
      stmt = DB.prepare(sql);
      stmt.setLong(1, key.longValue());
      stmt.executeQuery();
      rs.next();
      result = load(rs);
    } catch (Exception e) { throw new ApplicationException (e);
    } finally {DB.cleanUp(stmt, rs);
    }
    return result;
  }
  
  private UnitOfWork uow;
  protected DataMap dataMap;
  
  public DomainObject load(ResultSet rs) 
    throws InstantiationException, IllegalAccessException, SQLException
  {
    Long key = new Long(rs.getLong("ID"));
    if (uow.isLoaded(key)) return uow.getObject(key);
    DomainObject result = (DomainObject) dataMap.getDomainClass().newInstance();
    result.setID(key);
    uow.registerClean(result);
    loadFields(rs, result);
    return result;
  }
  
  private void loadFields(ResultSet rs, DomainObject result) throws SQLException {
    for (Iterator it = dataMap.getColumns(); it.hasNext();) {
      ColumnMap columnMap = (ColumnMap) it.next():
      Object columnValue = rs.getObject(columnMap.getColumnName());
      columnMap.setField(result, columnValue);
    }
  }
  
  public void update(DomainObject obj) {
    String sql = "UPDATE " + dataMap.getTableName() + dataMap.updateList() + " WHERE ID = ?";
    PreparedStatement stmt = null;
    try {
      stmt = DB.prepare(sql);
      int argCount = 1;
      for (Iterator it = dataMap.getColumns(); it.hasNext();) {
        ColumnMap col = (ColumnMap) it.next();
        stmt.setObject(argCount++, col.getValue(obj));
      }
      stmt.setLong(argCount, obj.getID().longValue());
      stmt.executeUpdate();
    } catch (SQLException e) {throw new ApplicationException (e);
    } finally {DB.cleanUp(stmt);
    }
  }
  
  
  
  public Long insert(DomainObject obj) {
    String sql = "INSERT INTO " + dataMap.getTableName() + " VALUES (?" + dataMap.insertList() + ")";
    PreparedStatemet stmt = null;
    try {
      stmt = DB.prepare(sql);
      stmt.setObject(1, obj.getID());
      int argCount = 2;
      for (Iterator it = dataMap.getColumns(); it.hasNext();) {
        ColumnMap col = (ColumnMap) it.next();
        stmt.setObject(argCount++, col.getValue(obj));
      }
      stmt.executeUpdate();
    } catch (SQLExecute e) {throw new ApplicationException (e);
    } finally {DB.cleanUp(stmt);
    }
    return obj.getID();
  }
  
  
  public Set findObjectsWhere (String whereClause) {
    String sql = "SELECT " + dataMap.columnList() + " FROM " + dataMap.getTableName() + " WHERE " 
       + whereClause;
    PreparedStatement stmt = null;
    ResultSet rs = null;
    Set result = new HashSet();
    try {
      stmt = DB.prepare(sql);
      rs = stmt.executeQuery();
      result = loadAll(rs);
    } catch (Exception e) {
      throw new ApplicationException (e);
    } finally {DB.cleanUp(stmt, rs);
    }
    return result;
  }
  
  public Set loadAll(Result rs) throws SQLException, InstantiationException, IllegalAccessException {
    Set result = new HashSet();
    while (rs.next()) {
      DomainObject newObj = (DomainObject) dataMap.getDomainClass().newInstance();
      newObj = load (rs);
      result.add(newObj);
    }
    return result;
  }
  
}

//###########################################################

class ColumnMap {
  
  public void setField(Object result, Object columnValue) {
    try {
      field.set(result, columnValue);
    } catch (Exception e) { throw new ApplicationException("Bd podczas okrelania wartoci pola " + fieldName, e);
    }
  }
  
  public Object getValue(Object subject) {
    try {
      return field.get(subject);
    } catch (Exception e) {
      throw new ApplicationException(e);
    }
  }
  
}

//###########################################################

class PersonMapper {

  public Person find(Long key) {
    return (Person) findObject(key);
  }
  
  public Set findLastNameLike (String pattern) {
    String sql = 
            "SELECT " + dataMap.columnList() + 
            " FROM " + dataMap.getTableName() + 
            " WHERE UPPER(lastName) like UPPER(?)";
    PreparedStatement stmt = null;
    ResultSet rs = null;
    try {
      stmt = DB.prepare(sql);
      stmt.setString(1, pattern);
      rs = stmt.executeQuery(rs);
      return loadAll(rs);
    } catch (Exception e) { throw new ApplicationException (e);
    } finally {DB.cleanUp(stmt,rs);
    }
  }

}


//###########################################################
//## potrzebne do kompilacji

class Field {}

  
 