
class QueryObject {
  private Class klass;
  private List criteria = new ArrayList();
  
  public Set execute(UnitOfWork uow) {
    this.uow = uow;
    return uow.getMapper(klass).findObjectsWhere(generateWhereClause());
  }
  
  private String generateWhereClause() {
    StringBuffer result = new StringBuffer();
    for (Iterator it = criteria.iterator(); it.hasNext();) {
      Criteria c = (Criteria) it.next();
      if (result.length() != 0) 
        resutl.append(" AND ");
      result.append(c.generateSql(uow.getMapper(klass).getMapper()));
    }
    return result.toString();
  }
  
}

//###################################################################

class Criteria {
  private String sqlOperator;
  protected String field;
  protected Object value;
  
  public static Criteria greaterThen(String fieldName, int value) {
    return Criteria.greaterThen(fieldName, new Integer(value));
  }
  
  public static Criteria greaterThen(String fieldName, Object value) {
    return new Criteria(" > ", fieldName, value);
  }
  
  private Criteria(String sql, String field, Object value) {
    this.sqlOperator = sql;
    this.field = field;
    this.value = value;
  }
  
  //---
  QueryObject query = new QueryObject(Person.class);
  query.addCriteria(Criteria.greaterThen("numberOfDependants", 0));
  
  //---
  
  public String generateSQL(DataMap dataMap) {
    return dataMap.getColumnForField(field) + sqlOperator + value;
  }
  
  public static Criteria matches(String fieldName, String pattern) {
    return new MatchCriteria(fieldName, pattern);
  }
  
}

//###################################################################

class Person {
  private String lastName;
  private String firstName;
  private int numberOfDependants;
}

//###################################################################

class MatchCriteria extends Criteria {
  
  public String generateSql(DataMap dataMap) {
    return "UPPER(" + dataMap.getColumnForField(field) + ") LIKE UPPER('" + value + "')";
  }
  
}

//###################################################################

    QueryObject query = new QueryObject(Person.class);
    query.addCriteria(Criteria.greaterThen("numberOfDependants", 0);
    query.addCriteria(Criteria.matches("lastName", "f%");

//###################################################################


