class HelperInitTag extends HelperTag {
  
  private String helperClassName;
  
  public void setName(String helperClassName) {
    this.helperClassName = helperClassName;
  }
  
  public int doStartTag() throws JspException {
    HelperController helper = null;
    try {
      helper = (HelperController) Class.forName(helperClassName).newInstance();
    } catch (Exception e) {
      throw new ApplicationException("Nie mona zainicjowa obiektu klasy " + helperClassName, e);
    }
    initHelper(helper);
    pageContext.setAttribute(HELPER, helper);
    return SKIP_BODY;
  }
 
  private void initHelper(HelperController helper) {
    HttpServletRequest request = (HttpServletRequest) pageContext.getRequest();
    HttpServletResponse response = (HttpServletResponse) pageContext.getResponse();
    helper.init(request, response);
  }
  
}

//###################################################################

class HelperTag {
  
  public static final String HELPER = "helper";
  
  //---
  
  protected Object getProperty(String property) throws JspException {
    Object helper = getHelper();
    try {
      final Method getter = helper.getClass().getMethod(gettingMethod(property), null);
      return getter.invoke(helper, null);
    } catch (Exceptione) {
      throw new JspException( 
        "Nie mona wywoa metody " + gettingMethod(property) + " - " + e.getMessage());
    }
  }
  
  private Object getHelper() throws JspException {
    Object helper = pageContext.getAttribute(HELPER);
    if (helper == null) throw new JspException("Nie znaleziono obiektu pomocniczego");
    return helper;
  }
  
  private String gettingMethod(String property) {
    String methodName = "get" + property.substring(0, 1).toUpperCase() +
                        property.substring(1);
    return methodName;
  }
  
}

//###################################################################

class HelperGetTag extends HelperTag {
  
  private String propertyName;
  
  public void setProperty(String propertyName) {
    this.propertyName = propertyName;
  }
  
  public int doStartTag() throws JspException {
    try {
      pageContext.getOut().print(getProperty(propertyName));
    } catch (IOException e) {
      throw new JspException("Nie mona wywietli informacji.");
    }
    return SKIP_BODY;
  }
  
}

//##




