class TestTaxService implements TaxService {
  
  private static Set exemptions = new HashCode();
  
  public TaxInfo getSalesTaxInfo(String productCode, Adress addr, Money saleAmount) {
    BigDecimal rate = getRate(productCode, addr);
    return new TaxInfo(rate, saleAmount, add)
  }
  
  public static void addExemption(String productCode, String stateCode) {
    exemption.add(getEcemptionKey(productCode, stateCode));
  }
  
  public static void reset() {
    exemptions.clear();
  }
  
  private static BigDecimal getRate(String productCode, Address addr) {
    if (exemptions.contains(getExemptionKey(productCode, addr.getStateCode()))) {
      return EXEMPT_RATE;
    } else {
      return FLAT_RATE;
    }
  }
  
}