public class Person {
  public List dependants() {
    Repository repository = Registry.personRepository();
    Criteria criteria = new Criteria();
    criteria.equal(Person.BENEFACTOR, this);
    return repository.matching(criteria);
  }
  
  //--- 2. wersja
  public List dependants() {
    return Registry.personRepository().dependantsOf(this);
  }
  
}

//#########################################################

public class PersonRepository extends Repository {
  public List dependantsOf(Person aPerson) {
    Criteria criteria = new Criteria();
    criteria.equal(Person.BENEFACTOR, aPerson);
    return matching(criteria);
  }
}


//#########################################################

abstract class Repository {
  private RepositoryStrategy strategy;
  protected List matching(Criteria aCriteria) {
    return strategy.matching(aCriteria);
  }
}

//#########################################################

public class RelationalStrategy implements RepositoryStrategy {
  protected List matching(Criteria criteria) {
    Query query = new Query(myDomainObjectClass());
    query.addCriteria(criteria);
    return query.execute(unitOfWork());
  }
}

//#########################################################

public class InMemoryStrategy implements RepositoryStrategy {
  private Set domainObjects;
  protected List matching(Criteria criteria) {
    List result = new ArrayList();
    Iterator it = domainObjects.iterator();
    while (it.hasNext()) {
      DomainObject each = (DomainObject) it.next();
      if (criteria.isSatisfiedBy(each))
        result.add(each);
    }
  }
}

//##


