/**
 * Copyright (C) 2015 Roland Kuhn <http://rolandkuhn.com>
 */
package com.reactivedesignpatterns.chapter15;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class RequestResponse {
	private static final int SERVER_PORT = 8888;

	static public class Server {
		static public void main(String[] args) throws IOException {
			// Utworzenie gniazda do odbierania datagramów.
			try (final DatagramSocket socket = new DatagramSocket(SERVER_PORT)) {

				// Odebranie datagramu.
				final byte[] buffer = new byte[1500];
				final DatagramPacket packet1 = new DatagramPacket(buffer, buffer.length);
				socket.receive(packet1);

				final SocketAddress sender = packet1.getSocketAddress();
				System.out.println("serwer: zapytanie " + new String(packet1.getData()));
				System.out.println("serwer: nadawca " + sender);

				// Wysłanie odpowiedzi.
				final byte[] response = "Udało się!".getBytes();
				final DatagramPacket packet2 = new DatagramPacket(response, response.length, sender);
				socket.send(packet2);
			}
		}
	}

	static public class Client {
		static public void main(String[] args) throws IOException {
			// Utworzenie lokalnego gniazda z dowolnie wybranym portem.
			try (final DatagramSocket socket = new DatagramSocket()) {

				// Wysłanie datagramu do serwera.
				final byte[] request = "Cześć!".getBytes();
				final DatagramPacket packet1 = new DatagramPacket(request, request.length,
						new InetSocketAddress("localhost", SERVER_PORT));
				socket.send(packet1);

				// Oczekiwanie na jeden datagram.
				final byte[] buffer = new byte[1500];
				final DatagramPacket packet2 = new DatagramPacket(buffer, buffer.length);
				socket.receive(packet2);

				final SocketAddress sender = packet2.getSocketAddress();
				System.out.println("klient: odpowiedź " + new String(packet2.getData()));
				System.out.println("klient: nadawca " + sender);
			}
		}
	}

}
