package org.reactivedesignpatterns.chapter2.future;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(JUnit4.class)
public class ParallelRetrieverExampleTest {
    final Customer customer1 = new Customer() {
        @Override
        public long getId() {
            return 1234L;
        }

        @Override
        public String getName() {
            return "Anna Nowak";
        }

        @Override
        public String getAddress() {
            return "ul. Nowa 111, 00-122 Warszawa";
        }

        @Override
        public String getPhone() {
            return "321-54-76";
        }
    };

    final Customer customer2 = new Customer() {
        @Override
        public long getId() {
            return 5678L;
        }

        @Override
        public String getName() {
            return "Jan Nowak";
        }

        @Override
        public String getAddress() {
            return "ul. Stara 222, 00-122 Warszawa";
        }

        @Override
        public String getPhone() {
            return "543-65-76";
        }
    };

    final CacheRetriever workingCacheRetriever = new CacheRetriever() {
        @Override
        public Customer getCustomer(long customerId) {
            return customer1;
        }
    };

    final CacheRetriever delayedCacheRetriever = new CacheRetriever() {
        @Override
        public Customer getCustomer(long customerId) {
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            return null;
        }
    };

    final DBRetriever workingDbRetriever = new DBRetriever() {
        @Override
        public Customer getCustomer(long customerId) {
            return customer2;
        }
    };

    final DBRetriever delayedDbRetriever = new DBRetriever() {
        @Override
        public Customer getCustomer(long customerId) {
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            return null;
        }
    };

    @Test
    public void testCacheReturn() {
        ParallelRetrievalExample retreiver = new ParallelRetrievalExample(
                workingCacheRetriever, delayedDbRetriever);
        Object retrievedCustomer = retreiver.retrieveCustomer(1234);
        org.junit.Assert.assertNotEquals(retrievedCustomer, null);
        // org.junit.Assert.assertEquals(retrievedCustomer.getId(), "1234");
    }

    @Test
    public void testDbReturn() {
        ParallelRetrievalExample retreiver = new ParallelRetrievalExample(
                delayedCacheRetriever, workingDbRetriever);
        Object retrievedCustomer = retreiver.retrieveCustomer(5678);
        org.junit.Assert.assertNotEquals(retrievedCustomer, null);
    }
}
