package org.reactivedesignpatterns.chapter2.future

import org.junit.Test
import org.junit.runner.RunWith
import org.junit.runners.JUnit4
import scala.concurrent.duration._
import scala.concurrent.ExecutionContext
import java.util.concurrent.ForkJoinPool
import org.junit.runner.RunWith
import scala.util.Try
import org.junit.runner.RunWith

@RunWith(classOf[JUnit4])
class ParallelRetrievalPromiseExampleTest {
  implicit val ec = ExecutionContext.fromExecutor(new ForkJoinPool())
  implicit val timeout = 250 milliseconds

  val customer1 = new Customer() {
    override def getId = 1234L
    override def getName = "Anna Nowak"
    override def getAddress = "ul. Nowa 111, 00-122 Warszawa"
    override def getPhone = "321-54-76"
  }

  val customer2 = new Customer() {
    override def getId = 5678L
    override def getName = "Jan Nowak"
    override def getAddress = "ul. Stara 222, 00-122 Warszawa"
    override def getPhone = "543-65-76"
  }

  val workingCacheRetriever = new CacheRetriever() {
    override def getCustomer(customerId: Long) = customer1
  }

  val delayedCacheRetriever = new CacheRetriever() {
    override def getCustomer(customerId: Long) = {
      Try(Thread.sleep(1000))
      null
    }
  }

  val workingDbRetriever = new DBRetriever() {
    override def getCustomer(customerId: Long) = customer2
  }

  val delayedDbRetriever = new DBRetriever() {
    override def getCustomer(customerId: Long) = {
      Try(Thread.sleep(1000))
      null
    }
  }

  @Test
  def testCacheReturn = {
    val retreiver = new ParallelRetrievalPromiseExample(
      workingCacheRetriever, delayedDbRetriever)
    val retrievedCustomer = retreiver.retrieveCustomer(1234)
    org.junit.Assert.assertNotEquals(retrievedCustomer, null)
  }

  @Test
  def testDbReturn() = {
    val retreiver = new ParallelRetrievalPromiseExample(
      delayedCacheRetriever, workingDbRetriever);
    val retrievedCustomer = retreiver.retrieveCustomer(5678);
    org.junit.Assert.assertNotEquals(retrievedCustomer, null);
  }
}