<?php

class propelImportdanychTask extends sfBaseTask {

    protected function configure() {
        // // add your own arguments here
        // $this->addArguments(array(
        //   new sfCommandArgument('my_arg', sfCommandArgument::REQUIRED, 'My argument'),
        // ));

        $this->addOptions(array(
            new sfCommandOption('application', null, sfCommandOption::PARAMETER_REQUIRED, 'The application name'),
            new sfCommandOption('env', null, sfCommandOption::PARAMETER_REQUIRED, 'The environment', 'dev'),
            new sfCommandOption('connection', null, sfCommandOption::PARAMETER_REQUIRED, 'The connection name', 'propel'),
                // add your own options here
        ));

        $this->namespace = 'propel';
        $this->name = 'import-danych';
        $this->briefDescription = '';
        $this->detailedDescription = <<<EOF
The [propel:import-danych|INFO] task does things.
Call it with:

  [php symfony propel:import-danych|INFO]
EOF;
    }

    protected function execute($arguments = array(), $options = array()) {
        // initialize the database connection
        $databaseManager = new sfDatabaseManager($this->configuration);
        $connection = $databaseManager->getDatabase($options['connection'])->getConnection();

        // add your code here

        require_once 'lib/slugs.inc.php';



        $plk = file('data/kontynenty.txt');
        shuffle($plk);
        foreach ($plk as $l) {
            $e = explode(',', trim($l));
            $e = array_map('trim', $e);
            $str_kontynent = $e[0];
            array_shift($e);
            shuffle($e);

            $c = new Criteria();
            $c->add(KontynentPeer::NAZWA, $str_kontynent);
            $kontynent = KontynentPeer::doSelectOne($c);
            if (!$kontynent) {
                $kontynent = new Kontynent();
                $kontynent->setNazwa($str_kontynent);
                $kontynent->setSlug(string2slug($str_kontynent));
                $kontynent->save();
            }

            foreach ($e as $str_panstwo) {
                $c = new Criteria();
                $c->add(PanstwoPeer::NAZWA, $str_panstwo);
                $panstwo = PanstwoPeer::doSelectOne($c);
                if (!$panstwo) {
                    $panstwo = new Panstwo();
                    $panstwo->setNazwa($str_panstwo);
                    $panstwo->setSlug(string2slug($str_panstwo));
                    $panstwo->setKontynent($kontynent);
                    $panstwo->save();
                }
            }
        }
    }

}
