
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- kontynent
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `kontynent`;


CREATE TABLE `kontynent`
(
	`kontynent_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(45),
	`slug` VARCHAR(45),
	PRIMARY KEY (`kontynent_id`),
	UNIQUE KEY `u_slug` (`slug`)
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- panstwo
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `panstwo`;


CREATE TABLE `panstwo`
(
	`panstwo_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(45),
	`slug` VARCHAR(45),
	`kontynent_id` INTEGER  NOT NULL,
	PRIMARY KEY (`panstwo_id`),
	UNIQUE KEY `u_slug` (`slug`),
	KEY `fk_panstwo_kontynent`(`kontynent_id`),
	CONSTRAINT `panstwo_FK_1`
		FOREIGN KEY (`kontynent_id`)
		REFERENCES `kontynent` (`kontynent_id`)
)Type=InnoDB;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
