<?php

/**
 * Miasto filter form base class.
 *
 * @package    kontynenty
 * @subpackage filter
 * @author     Your name here
 */
abstract class BaseMiastoFormFilter extends BaseFormFilterPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'nazwa'      => new sfWidgetFormFilterInput(),
      'slug'       => new sfWidgetFormFilterInput(),
      'panstwo_id' => new sfWidgetFormPropelChoice(array('model' => 'Panstwo', 'add_empty' => true)),
    ));

    $this->setValidators(array(
      'nazwa'      => new sfValidatorPass(array('required' => false)),
      'slug'       => new sfValidatorPass(array('required' => false)),
      'panstwo_id' => new sfValidatorPropelChoice(array('required' => false, 'model' => 'Panstwo', 'column' => 'panstwo_id')),
    ));

    $this->widgetSchema->setNameFormat('miasto_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Miasto';
  }

  public function getFields()
  {
    return array(
      'miasto_id'  => 'Number',
      'nazwa'      => 'Text',
      'slug'       => 'Text',
      'panstwo_id' => 'ForeignKey',
    );
  }
}
