<?php

/**
 * Pu form base class.
 *
 * @method Pu getObject() Returns the current form's model object
 *
 * @package    noth
 * @subpackage form
 * @author     Your name here
 */
abstract class BasePuForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'pu_id' => new sfWidgetFormInputHidden(),
      'tytul' => new sfWidgetFormInputText(),
      'tresc' => new sfWidgetFormTextarea(),
      'slug'  => new sfWidgetFormInputText(),
    ));

    $this->setValidators(array(
      'pu_id' => new sfValidatorChoice(array('choices' => array($this->getObject()->getPuId()), 'empty_value' => $this->getObject()->getPuId(), 'required' => false)),
      'tytul' => new sfValidatorString(array('max_length' => 128, 'required' => false)),
      'tresc' => new sfValidatorString(array('required' => false)),
      'slug'  => new sfValidatorString(array('max_length' => 128, 'required' => false)),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorPropelUnique(array('model' => 'Pu', 'column' => array('slug')))
    );

    $this->widgetSchema->setNameFormat('pu[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Pu';
  }


}
