<?php

/**
 * Menu form base class.
 *
 * @method Menu getObject() Returns the current form's model object
 *
 * @package    noth
 * @subpackage form
 * @author     Your name here
 */
abstract class BaseMenuForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'menu_id' => new sfWidgetFormInputHidden(),
      'tytul'   => new sfWidgetFormInputText(),
      'tresc'   => new sfWidgetFormTextarea(),
      'slug'    => new sfWidgetFormInputText(),
    ));

    $this->setValidators(array(
      'menu_id' => new sfValidatorChoice(array('choices' => array($this->getObject()->getMenuId()), 'empty_value' => $this->getObject()->getMenuId(), 'required' => false)),
      'tytul'   => new sfValidatorString(array('max_length' => 128, 'required' => false)),
      'tresc'   => new sfValidatorString(array('required' => false)),
      'slug'    => new sfValidatorString(array('max_length' => 128, 'required' => false)),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorPropelUnique(array('model' => 'Menu', 'column' => array('slug')))
    );

    $this->widgetSchema->setNameFormat('menu[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Menu';
  }


}
