<?php

/**
 * Grupa form base class.
 *
 * @method Grupa getObject() Returns the current form's model object
 *
 * @package    noth
 * @subpackage form
 * @author     Your name here
 */
abstract class BaseGrupaForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'grupa_id'  => new sfWidgetFormInputHidden(),
      'skroty_id' => new sfWidgetFormPropelChoice(array('model' => 'Skroty', 'add_empty' => true)),
    ));

    $this->setValidators(array(
      'grupa_id'  => new sfValidatorChoice(array('choices' => array($this->getObject()->getGrupaId()), 'empty_value' => $this->getObject()->getGrupaId(), 'required' => false)),
      'skroty_id' => new sfValidatorPropelChoice(array('model' => 'Skroty', 'column' => 'skroty_id', 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('grupa[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Grupa';
  }


}
