<?php

/**
 * Kierunek filter form base class.
 *
 * @package    angaze
 * @subpackage filter
 * @author     Your name here
 */
abstract class BaseKierunekFormFilter extends BaseFormFilterPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'nazwa'            => new sfWidgetFormFilterInput(),
      'skrot'            => new sfWidgetFormFilterInput(),
      'sortowanie'       => new sfWidgetFormFilterInput(),
      'wydzial_id'       => new sfWidgetFormPropelChoice(array('model' => 'Wydzial', 'add_empty' => true)),
      'rodzajstudiow_id' => new sfWidgetFormPropelChoice(array('model' => 'Rodzajstudiow', 'add_empty' => true)),
      'slug'             => new sfWidgetFormFilterInput(array('with_empty' => false)),
    ));

    $this->setValidators(array(
      'nazwa'            => new sfValidatorPass(array('required' => false)),
      'skrot'            => new sfValidatorPass(array('required' => false)),
      'sortowanie'       => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'wydzial_id'       => new sfValidatorPropelChoice(array('required' => false, 'model' => 'Wydzial', 'column' => 'wydzial_id')),
      'rodzajstudiow_id' => new sfValidatorPropelChoice(array('required' => false, 'model' => 'Rodzajstudiow', 'column' => 'rodzajstudiow_id')),
      'slug'             => new sfValidatorPass(array('required' => false)),
    ));

    $this->widgetSchema->setNameFormat('kierunek_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Kierunek';
  }

  public function getFields()
  {
    return array(
      'kierunek_id'      => 'Number',
      'nazwa'            => 'Text',
      'skrot'            => 'Text',
      'sortowanie'       => 'Number',
      'wydzial_id'       => 'ForeignKey',
      'rodzajstudiow_id' => 'ForeignKey',
      'slug'             => 'Text',
    );
  }
}
