<?php

/**
 * Rodzajstudiow form base class.
 *
 * @method Rodzajstudiow getObject() Returns the current form's model object
 *
 * @package    angaze
 * @subpackage form
 * @author     Your name here
 */
abstract class BaseRodzajstudiowForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'rodzajstudiow_id' => new sfWidgetFormInputHidden(),
      'nazwa'            => new sfWidgetFormInputText(),
      'skrot'            => new sfWidgetFormInputText(),
      'semestry'         => new sfWidgetFormInputText(),
      'lata'             => new sfWidgetFormInputText(),
      'slug'             => new sfWidgetFormInputText(),
    ));

    $this->setValidators(array(
      'rodzajstudiow_id' => new sfValidatorChoice(array('choices' => array($this->getObject()->getRodzajstudiowId()), 'empty_value' => $this->getObject()->getRodzajstudiowId(), 'required' => false)),
      'nazwa'            => new sfValidatorString(array('max_length' => 45, 'required' => false)),
      'skrot'            => new sfValidatorString(array('max_length' => 20, 'required' => false)),
      'semestry'         => new sfValidatorInteger(array('min' => -2147483648, 'max' => 2147483647, 'required' => false)),
      'lata'             => new sfValidatorInteger(array('min' => -2147483648, 'max' => 2147483647, 'required' => false)),
      'slug'             => new sfValidatorString(array('max_length' => 128)),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorPropelUnique(array('model' => 'Rodzajstudiow', 'column' => array('slug')))
    );

    $this->widgetSchema->setNameFormat('rodzajstudiow[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Rodzajstudiow';
  }


}
