<?php

class propelPrzeliczTask extends sfBaseTask
{
  protected function configure()
  {
    // // add your own arguments here
    // $this->addArguments(array(
    //   new sfCommandArgument('my_arg', sfCommandArgument::REQUIRED, 'My argument'),
    // ));

    $this->addOptions(array(
      new sfCommandOption('application', null, sfCommandOption::PARAMETER_REQUIRED, 'The application name'),
      new sfCommandOption('env', null, sfCommandOption::PARAMETER_REQUIRED, 'The environment', 'dev'),
      new sfCommandOption('connection', null, sfCommandOption::PARAMETER_REQUIRED, 'The connection name', 'propel'),
      // add your own options here
    ));

    $this->namespace        = 'propel';
    $this->name             = 'przelicz';
    $this->briefDescription = '';
    $this->detailedDescription = <<<EOF
The [propel:przelicz|INFO] task does things.
Call it with:

  [php symfony propel:przelicz|INFO]
EOF;
  }

  protected function execute($arguments = array(), $options = array())
  {
    // initialize the database connection
    $databaseManager = new sfDatabaseManager($this->configuration);
    $connection = $databaseManager->getDatabase($options['connection'])->getConnection();

    // add your code here




    $projekty = ProjektPeer::doSelect(new Criteria());
    foreach ($projekty as $projekt) {
        $projekt->ustalLiczbeCzcionek();
    }


    $czcionki = CzcionkaPeer::doSelect(new Criteria());
    foreach ($czcionki as $czcionka) {
        $czcionka->ustalLiczbeProjektow();
    }


    $rodziny = RodzinaPeer::doSelect(new Criteria());
    foreach ($rodziny as $rodzina) {
        $rodzina->ustalLiczbeProjektow();
        $rodzina->ustalLiczbeCzcionek();
    }

  }
}
