<?php

/**
 * zadanie actions.
 *
 * @package    cpp
 * @subpackage zadanie
 * @author     Your name here
 */
class zadanieActions extends sfActions
{
  public function executeIndex(sfWebRequest $request)
  {
    $this->Zadanies = ZadaniePeer::doSelect(new Criteria());
    $this->getUser()->setAttribute('prevUrl', 'zadanie/index');
  }

  public function executeNew(sfWebRequest $request)
  {
    $this->form = new ZadanieForm();
    if (
        $request->getParameter('rozdzial_id') &&
        ($this->Rozdzial = RozdzialPeer::retrieveByPk($request->getParameter('rozdzial_id')))
    ) {
        $this->form->getWidget('rozdzial_id')->setDefault($this->Rozdzial->getRozdzialId());
        $numer = $this->Rozdzial->getMaxNumerZadania();
        $this->form->getWidget('numer')->setDefault($numer + 1);
        $this->form->getWidget('slug')->setDefault(myString::slugZadania($this->Rozdzial->getNumer(), $numer + 1));
    }
  }

  public function executeCreate(sfWebRequest $request)
  {
    $this->forward404Unless($request->isMethod(sfRequest::POST));

    $this->form = new ZadanieForm();

    $this->processForm($request, $this->form);

    $this->setTemplate('new');
  }

  public function executeEdit(sfWebRequest $request)
  {
    $this->forward404Unless($Zadanie = ZadaniePeer::retrieveByPk($request->getParameter('zadanie_id')), sprintf('Object Zadanie does not exist (%s).', $request->getParameter('zadanie_id')));
    $this->form = new ZadanieForm($Zadanie);
    $this->Zadanie = $Zadanie;
  }

  public function executeUpdate(sfWebRequest $request)
  {
    $this->forward404Unless($request->isMethod(sfRequest::POST) || $request->isMethod(sfRequest::PUT));
    $this->forward404Unless($Zadanie = ZadaniePeer::retrieveByPk($request->getParameter('zadanie_id')), sprintf('Object Zadanie does not exist (%s).', $request->getParameter('zadanie_id')));
    $this->form = new ZadanieForm($Zadanie);

    $this->processForm($request, $this->form);

    $this->setTemplate('edit');
  }

  public function executeDelete(sfWebRequest $request)
  {
    $request->checkCSRFProtection();

    $this->forward404Unless($Zadanie = ZadaniePeer::retrieveByPk($request->getParameter('zadanie_id')), sprintf('Object Zadanie does not exist (%s).', $request->getParameter('zadanie_id')));
    $Rozdzial = $Zadanie->getRozdzial();
    $Zadanie->delete();

    $url = $this->getUser()->getAttribute('prevUrl', 'zadanie/index');
    $this->redirect($url);
  }

  protected function processForm(sfWebRequest $request, sfForm $form)
  {
    $form->bind($request->getParameter($form->getName()), $request->getFiles($form->getName()));
    if ($form->isValid())
    {
      $Zadanie = $form->save();
      
      if (trim($Zadanie->getSlug()) == '') {
          $Zadanie->setSlug('');
          
      }
      $this->redirect('zadanie/edit?zadanie_id='.$Zadanie->getZadanieId());
    }
  }
}
