<?php

/**
 * Rozdzial form base class.
 *
 * @method Rozdzial getObject() Returns the current form's model object
 *
 * @package    cpp
 * @subpackage form
 * @author     Your name here
 */
abstract class BaseRozdzialForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'rozdzial_id' => new sfWidgetFormInputHidden(),
      'tytul'       => new sfWidgetFormInputText(),
      'slug'        => new sfWidgetFormInputText(),
      'numer'       => new sfWidgetFormInputText(),
    ));

    $this->setValidators(array(
      'rozdzial_id' => new sfValidatorChoice(array('choices' => array($this->getObject()->getRozdzialId()), 'empty_value' => $this->getObject()->getRozdzialId(), 'required' => false)),
      'tytul'       => new sfValidatorString(array('max_length' => 128, 'required' => false)),
      'slug'        => new sfValidatorString(array('max_length' => 128, 'required' => false)),
      'numer'       => new sfValidatorInteger(array('min' => -2147483648, 'max' => 2147483647, 'required' => false)),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorPropelUnique(array('model' => 'Rozdzial', 'column' => array('numer')))
    );

    $this->widgetSchema->setNameFormat('rozdzial[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Rozdzial';
  }


}
