<?php

/**
 * Plik form base class.
 *
 * @method Plik getObject() Returns the current form's model object
 *
 * @package    pliki-do-pobrania
 * @subpackage form
 * @author     Your name here
 */
abstract class BasePlikForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'plik_id' => new sfWidgetFormInputHidden(),
      'dane'    => new sfWidgetFormInputText(),
      'slug'    => new sfWidgetFormInputText(),
      'typmime' => new sfWidgetFormInputText(),
    ));

    $this->setValidators(array(
      'plik_id' => new sfValidatorChoice(array('choices' => array($this->getObject()->getPlikId()), 'empty_value' => $this->getObject()->getPlikId(), 'required' => false)),
      'dane'    => new sfValidatorPass(array('required' => false)),
      'slug'    => new sfValidatorString(array('max_length' => 128, 'required' => false)),
      'typmime' => new sfValidatorString(array('max_length' => 128, 'required' => false)),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorPropelUnique(array('model' => 'Plik', 'column' => array('slug')))
    );

    $this->widgetSchema->setNameFormat('plik[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Plik';
  }


}
