<?php

/**
 * BaseArticle
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property integer $author_id
 * @property boolean $is_on_homepage
 * @property string $title
 * @property string $body
 * @property string $test_column
 * @property integer $views
 * @property string $type
 * @property Author $Author
 * @property Doctrine_Collection $camelCase
 * 
 * @method integer             getAuthorId()       Returns the current record's "author_id" value
 * @method boolean             getIsOnHomepage()   Returns the current record's "is_on_homepage" value
 * @method string              getTitle()          Returns the current record's "title" value
 * @method string              getBody()           Returns the current record's "body" value
 * @method string              getTestColumn()     Returns the current record's "test_column" value
 * @method integer             getViews()          Returns the current record's "views" value
 * @method string              getType()           Returns the current record's "type" value
 * @method Author              getAuthor()         Returns the current record's "Author" value
 * @method Doctrine_Collection getCamelCase()      Returns the current record's "camelCase" collection
 * @method Article             setAuthorId()       Sets the current record's "author_id" value
 * @method Article             setIsOnHomepage()   Sets the current record's "is_on_homepage" value
 * @method Article             setTitle()          Sets the current record's "title" value
 * @method Article             setBody()           Sets the current record's "body" value
 * @method Article             setTestColumn()     Sets the current record's "test_column" value
 * @method Article             setViews()          Sets the current record's "views" value
 * @method Article             setType()           Sets the current record's "type" value
 * @method Article             setAuthor()         Sets the current record's "Author" value
 * @method Article             setCamelCase()      Sets the current record's "camelCase" collection
 * 
 * @package    symfony12
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseArticle extends myDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('article');
        $this->hasColumn('author_id', 'integer', null, array(
             'type' => 'integer',
             ));
        $this->hasColumn('is_on_homepage', 'boolean', null, array(
             'type' => 'boolean',
             ));
        $this->hasColumn('title', 'string', 255, array(
             'type' => 'string',
             'unique' => true,
             'length' => 255,
             ));
        $this->hasColumn('body', 'string', 255, array(
             'type' => 'string',
             'length' => 255,
             ));
        $this->hasColumn('test_column', 'string', 255, array(
             'type' => 'string',
             'length' => 255,
             ));
        $this->hasColumn('views', 'integer', null, array(
             'type' => 'integer',
             ));
        $this->hasColumn('type', 'string', 255, array(
             'type' => 'string',
             'length' => 255,
             ));

        $this->setSubClasses(array(
             'BlogArticle' => 
             array(
              'type' => 'BlogArticle',
             ),
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Author', array(
             'local' => 'author_id',
             'foreign' => 'id'));

        $this->hasMany('CamelCase as camelCase', array(
             'local' => 'id',
             'foreign' => 'article_id'));

        $i18n0 = new Doctrine_Template_I18n(array(
             'fields' => 
             array(
              0 => 'title',
              1 => 'body',
              2 => 'test_column',
             ),
             ));
        $sluggable1 = new Doctrine_Template_Sluggable(array(
             'fields' => 
             array(
              0 => 'title',
             ),
             'uniqueBy' => 
             array(
              0 => 'lang',
              1 => 'title',
             ),
             ));
        $i18n0->addChild($sluggable1);
        $timestampable0 = new Doctrine_Template_Timestampable();
        $this->actAs($i18n0);
        $this->actAs($timestampable0);
    }
}