<?php

/**
 * Zawodnik filter form base class.
 *
 * @package    tcs
 * @subpackage filter
 * @author     Your name here
 */
abstract class BaseZawodnikFormFilter extends BaseFormFilterPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'imie'        => new sfWidgetFormFilterInput(),
      'nazwisko'    => new sfWidgetFormFilterInput(),
      'panstwo_id'  => new sfWidgetFormPropelChoice(array('model' => 'Panstwo', 'add_empty' => true)),
    ));

    $this->setValidators(array(
      'imie'        => new sfValidatorPass(array('required' => false)),
      'nazwisko'    => new sfValidatorPass(array('required' => false)),
      'panstwo_id'  => new sfValidatorPropelChoice(array('required' => false, 'model' => 'Panstwo', 'column' => 'panstwo_id')),
    ));

    $this->widgetSchema->setNameFormat('zawodnik_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Zawodnik';
  }

  public function getFields()
  {
    return array(
      'zawodnik_id' => 'Number',
      'imie'        => 'Text',
      'nazwisko'    => 'Text',
      'panstwo_id'  => 'ForeignKey',
    );
  }
}
