<?php

namespace My\FrontendBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * My\FrontendBundle\Entity\Method
 *
 * @ORM\Table()
 * @ORM\Entity(repositoryClass="My\FrontendBundle\Entity\MethodRepository")
 */
class Method
{
    /**
     * @var integer $id
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string $name
     *
     * @ORM\Column(name="name", type="string", length=255)
     */
    private $name;


    /**
     * @ORM\ManyToMany(targetEntity="Novel", mappedBy="methods")
     * @ORM\OrderBy({"title" = "ASC"})
     */
    protected $novels;

    /**
     * @var string $slug
     *
     * @Gedmo\Slug(fields={"name"})
     * @ORM\Column(length=255, unique=true)
     */
    private $slug;



    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function getName()
    {
        return $this->name;
    }
    public function __construct()
    {
        $this->novels = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Add novels
     *
     * @param My\FrontendBundle\Entity\Novel $novels
     */
    public function addNovel(\My\FrontendBundle\Entity\Novel $novels)
    {
        $novels->addMethod($this);

        $this->novels[] = $novels;
    }

    /**
     * Get novels
     *
     * @return Doctrine\Common\Collections\Collection 
     */
    public function getNovels()
    {
        return $this->novels;
    }

    /**
     * Set slug
     *
     * @param string $slug
     */
    public function setSlug($slug)
    {
        $this->slug = $slug;
    }

    /**
     * Get slug
     *
     * @return string 
     */
    public function getSlug()
    {
        return $this->slug;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function __toString()
    {
        return (string)$this->getName();
    }

}