<?php

namespace My\FrontendBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use My\FrontendBundle\Entity\Novel;

/**
 * Novel controller.
 *
 * @Route("/novel")
 */
class NovelController extends Controller
{
    /**
     * Lists all Novel entities.
     *
     * @Route("/index.html", name="novel")
     * @Template()
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getEntityManager();

        $entities = $em->getRepository('MyFrontendBundle:Novel')->findAll();

        return array('entities' => $entities);
    }

    /**
     * Finds and displays a Novel entity.
     *
     * @Route("/{slug}.html", name="novel_show")
     * @Template()
     */
    public function showAction($slug)
    {
        $em = $this->getDoctrine()->getEntityManager();

        $entity = $em->getRepository('MyFrontendBundle:Novel')->findOneBySlug($slug);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Novel entity.');
        }

        return array('entity' => $entity);
    }

}
