<?php

namespace My\FrontendBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

class FilmController extends Controller
{
    /**
     * Lista wszystkich filmow
     *
     * @Route("/filmy.html", name="film_index")
     * @Template()
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getEntityManager();
        $entities = $em->getRepository('MyFrontendBundle:Film')->findAll();
        return array('entities' => $entities);
    }

    /**
     * Szczegolowe dane filmu
     *
     * @Route("/film/{slug}.html", name="film_show")
     * @Template()
     */
    public function showAction($slug)
    {
        $em = $this->getDoctrine()->getEntityManager();
        $entity = $em->getRepository('MyFrontendBundle:Film')->findOneBySlug($slug);
        if (!$entity) {
            throw $this->createNotFoundException('Brak filmu o podanym slugu!');
        }
        return array('entity' => $entity);
    }

}